<?php
/**
 * Plugin Name: easychat AI Chatbot Integration
 * Plugin URI: https://easychat.ch/wordpress-plugin.html
 * Description: Easily integrate your AI chatbot from easychat.ch into your WordPress website – just enter your client, bot, and token, and the script will be added automatically.
 * Version: 1.1.1
 * Author: easychat.ch
 * Author URI: https://easychat.ch
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: easychat-ai-chatbot-integration
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Sicherheit

/**
 * Add menu item under "Settings"
 */
add_action('admin_menu', function() {
    add_options_page(
        'easychat AI Chatbot Integration',
        'easychat AI Chatbot',
        'manage_options',
        'easychat-ai-chatbot-integration',
        'easyaich_ai_chatbot_settings_page'
    );
});

/**
 * Register settings
 */
add_action('admin_init', function() {
    register_setting('easyaich_ai_chatbot_settings_group', 'easyaich_ai_chatbot_client', [
        'sanitize_callback' => 'sanitize_text_field'
    ]);
    register_setting('easyaich_ai_chatbot_settings_group', 'easyaich_ai_chatbot_bot', [
        'sanitize_callback' => 'sanitize_text_field'
    ]);
    register_setting('easyaich_ai_chatbot_settings_group', 'easyaich_ai_chatbot_token', [
        'sanitize_callback' => 'sanitize_text_field'
    ]);
});

/**
 * Settings page
 */
function easyaich_ai_chatbot_settings_page() { ?>
    <div class="wrap">
        <h1><?php echo esc_html__('easychat AI Chatbot Integration', 'easychat-ai-chatbot-integration'); ?></h1>
        <p><?php echo wp_kses_post('Enter your chatbot information from your <a href="https://easychat.ch" target="_blank">easychat dashboard</a>.'); ?></p>

        <form method="post" action="options.php">
            <?php settings_fields('easyaich_ai_chatbot_settings_group'); ?>
            <?php do_settings_sections('easyaich_ai_chatbot_settings_group'); ?>

            <table class="form-table" role="presentation">
                <tr>
                    <th scope="row"><label for="easyaich_ai_chatbot_client"><?php echo esc_html__('Client ID', 'easychat-ai-chatbot-integration'); ?></label></th>
                    <td><input type="text" name="easyaich_ai_chatbot_client" id="easyaich_ai_chatbot_client" value="<?php echo esc_attr(get_option('easyaich_ai_chatbot_client')); ?>" class="regular-text" placeholder="e.g. easychat"></td>
                </tr>
                <tr>
                    <th scope="row"><label for="easyaich_ai_chatbot_bot"><?php echo esc_html__('Bot Name', 'easychat-ai-chatbot-integration'); ?></label></th>
                    <td><input type="text" name="easyaich_ai_chatbot_bot" id="easyaich_ai_chatbot_bot" value="<?php echo esc_attr(get_option('easyaich_ai_chatbot_bot')); ?>" class="regular-text" placeholder="e.g. easychat"></td>
                </tr>
                <tr>
                    <th scope="row"><label for="easyaich_ai_chatbot_token"><?php echo esc_html__('Token', 'easychat-ai-chatbot-integration'); ?></label></th>
                    <td><input type="text" name="easyaich_ai_chatbot_token" id="easyaich_ai_chatbot_token" value="<?php echo esc_attr(get_option('easyaich_ai_chatbot_token')); ?>" class="regular-text" placeholder="e.g. 23ea08aefb3d85f80679d1668ec506e6"></td>
                </tr>
            </table>

            <?php submit_button(esc_html__('Save Settings', 'easychat-ai-chatbot-integration')); ?>
        </form>

        <hr style="margin: 30px 0;">
        <p><strong><?php echo esc_html__('Tip:', 'easychat-ai-chatbot-integration'); ?></strong> <?php echo esc_html__('The chatbot script will be automatically added to your website footer.', 'easychat-ai-chatbot-integration'); ?></p>
    </div>
<?php }

/**
 * Output the chatbot script in the frontend footer
 */
add_action('wp_footer', function() {
    $client = get_option('easyaich_ai_chatbot_client');
    $bot    = get_option('easyaich_ai_chatbot_bot');
    $token  = get_option('easyaich_ai_chatbot_token');

    if ($client && $bot && $token) {
        echo "\n" . esc_html('<!-- easychat AI Chatbot Integration -->') . "\n";
        printf(
            '<script src="%1$s" data-client="%2$s" data-bot="%3$s" data-api="%4$s" data-token="%5$s"></script>' . "\n",
            esc_url('https://bot.easychat.ch/chatwidget.js'),
            esc_attr($client),
            esc_attr($bot),
            esc_url('https://bot.easychat.ch/chat.php'),
            esc_attr($token)
        );
        echo esc_html('<!-- /easychat AI Chatbot Integration -->') . "\n";
    }
});
